/**
 * dtags-tags:
 * @title: dtags-tags
 * @subtitle: dtags-tags
 * @project: dtags
 * @lang: fr,en
 * @authors: Philippe Roy <ph_roy@toutdoux.org>
 * @copyright: Copyright (c) 2001 Philippe Roy
 * @license: GNU GPL
 *
 * fr: XMlisation des balises extraites par Exuberant Ctags
 *
 * en: Tags XMlization extracted by Exuberant Ctags
 **/

/*
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <fcntl.h>
#include <parser.h>
#include <tree.h>
/*  #include <libxml/parser.h> */
/*  #include <libxml/tree.h> */

#include "dtags-tags.h"

/*****************************************************************************/
/*** Standardisation du vocabulaire - Vocabulary standardization */
/*****************************************************************************/

#define XmlDoc xmlDoc
#define XmlNs xmlNs
#define XmlNode xmlNode
#define XmlAttribute xmlAttribute
#define XmlAttr xmlAttr
#define XmlChar xmlChar

/*****************************************************************************/
/*** Variables globales - Global variables */
/*****************************************************************************/

#define BUFFER_SIZE 256
#define MAX_RING 100
gchar *PACKAGE_COMMAND;
TdPopt popts[4];

/*****************************************************************************/
/*** Communs - Commons
/*****************************************************************************/

/**
 * string_file:
 * @file: file
 *
 * fr: Retourne le contenu du fichier
 *
 * en: Returns the file content
 *
 * Return value: string
 **/

GString* string_file (gchar *file)
{
  gint i;
  gint fd;
  GString *ret;
  GIOChannel *iochannel;
  char *buff;
  guint readden;
  buff = g_malloc0 (BUFFER_SIZE);
  ret = g_string_new ("");

  /* Go ! */
  fd = open (file, O_RDONLY);
  if (fd < 0)
    g_error ("dtags-tags: Loading file '%s' unreadable", file);
  iochannel = g_io_channel_unix_new (fd);
  g_io_channel_read (iochannel, buff, BUFFER_SIZE, &readden);
  if (readden == 0)
    return NULL;
  i=0;
  while (readden != 0)
    {
      g_string_append (ret, g_strdup (buff));
      g_free (buff);
      buff = g_malloc0 (BUFFER_SIZE);
      g_io_channel_read (iochannel, buff, BUFFER_SIZE, &readden);
    }
  close (fd);
  g_free (buff);
  return ret;
}

/*****************************************************************************/
/*** Arguments de la ligne de commande - Command line arguments */
/*****************************************************************************/

/**
 * popt_def:
 * @key: char key
 * @long key: string key
 * @argument: argument
 * @description: description
 *
 * fr: Cr une option de ligne de commande
 *
 * en: Creates an option of command line
 *
 * Return value: popt structure
 **/

TdPopt popt_def (gchar *key, gchar *longkey, gchar *argument, gchar *description)
{
  TdPopt ret = NULL;
  ret = g_malloc0 (sizeof (TdPopt_tmp));
  ret->key = g_strdup (key);
  ret->longkey = g_strdup (longkey);
  ret->argument = g_strdup (argument);
  ret->description = description;
  ret->flag = FALSE;
  ret->value = NULL;
  ret->nbpredef = 0;
  return ret;
}

/**
 * popts_help:
 * @nbpopts: counter of options of commande line
 * @popts[]: arraw of options of commande line options
 *
 * fr: Affiche l'usage
 *
 * en: Displays the usage
 **/

void popts_help (gint nbpopts, TdPopt popts[])
{
  gint i, j, k, key, longkey, argument;
  gint length = 0;

  /*** Alignement - Aligment */
  g_print ("%s [option ...]\n", PACKAGE_COMMAND);
  for (i=0; i<nbpopts; i++)
    {
      key = 0;
      longkey = 0;
      argument = 0;
      if (popts[i]->key)
	key = 3;
      if (popts[i]->longkey)
	longkey = strlen (popts[i]->longkey);
      if (popts[i]->argument)
	argument = strlen (popts[i]->argument);
      if (length < (9+key+longkey+argument))
	length = 9+key+longkey+argument;
    }


  /*** Texte - Text */
  for (i=0; i<nbpopts; i++)
    {
      g_print ("  ");
      key = 0;
      longkey = 0;
      argument = 0;
      if (popts[i]->key)
	{
	  g_print ("-%s, ", popts[i]->key);
	  key = 4;
	}
      if (popts[i]->longkey)
	{
	  g_print ("--%s ", popts[i]->longkey);
	  longkey = strlen (popts[i]->longkey);
	}
      if (popts[i]->argument)
	{
	  g_print ("%s", popts[i]->argument);
	  argument = strlen (popts[i]->argument);
	}
      for (j=7+key+longkey+argument; j<length; j++)
	g_print (" ");
      g_print ("%s\n", popts[i]->description);
      for (j=0; j<popts[i]->nbpredef; j++)
	{
	  for (k=0; k<length; k++)
	    g_print (" ");
	  g_print ("%s\n", popts[i]->predef[j]);
	}
    }
  exit (0);
}

/**
 * popts_parse:
 * @argc: counter of options used of command line
 * @argv[]: arraw of options used of command line
 * @nbpopts: counter of options of command line
 * @popts[]: arraw of options of command line
 *
 * fr: Analyse de la ligne de commande
 *
 * en: Parses the command line
 **/

void popts_parse (gint argc, char *argv[], gint nbpopts, TdPopt popts[])
{
  gint i, j;
  GList *option = NULL;
  GList *argument = NULL;
  gchar *txt_tmp = NULL;
  gchar *txt_tmp1 = NULL;
  gchar *txt_tmp2 = NULL;
  gboolean bool_tmp;

  /*** Dcoupage - Cutting */
  for (i=1; i<argc; i++)
    if (argv[i][0] == '-')
      {
	if (argv[i][1] == '-')
	  option = g_list_append (option, g_strdup (argv[i]+2));
	else
	  option = g_list_append (option, g_strdup (argv[i]+1));
	if (i!=1)
	  {
	    argument = g_list_append (argument, g_strdup (txt_tmp));
	    txt_tmp = "(null)";
	  }
      }
    else
      txt_tmp = g_strdup (argv[i]);
  if (i!=1)
    argument = g_list_append (argument, g_strdup (txt_tmp));

  /*** Affectation - Allocation */
  for (i=0; i<g_list_length (option); i++)
    {

      /*** Aide - Help */
      if ((!strcmp ("h", g_list_nth_data (option, i))) || (!strcmp ("help", g_list_nth_data (option, i))))
	{
	  popts_help (nbpopts, popts);
	  break;
	}
      if (!strcmp ("about", g_list_nth_data (option, i)))
	{
	  popts_about();
	  break;
	}
      if ((!strcmp ("v", g_list_nth_data (option, i))) || (!strcmp ("version", g_list_nth_data (option, i))))
	{
	  popts_version();
	  break;
	}

      /*** Application */
      bool_tmp = FALSE;
      for (j=0; j<nbpopts; j++)
	if (((popts[j]->key) && (!strcmp (popts[j]->key, g_list_nth_data (option, i)))) || 
	    ((popts[j]->longkey) && (!strcmp (popts[j]->longkey, g_list_nth_data (option, i)))))
	  {
	    popts[j]->flag = TRUE;
	    bool_tmp = TRUE;
	    if (g_list_nth_data (argument, i))
	      popts[j]->value = g_strdup (g_list_nth_data (argument, i));
	    else
	      if (popts[j]->argument)
		g_error ("dtags-tags: option '%s' needs argument '%s'", (gchar*) g_list_nth_data (option, i), popts[j]->argument);
	  }
      if (!bool_tmp)
	g_error ("dtags-tags: option '%s' unknow", (gchar*) g_list_nth_data (option, i));
    }
}

/**
 * popts_version:
 *
 * fr: Affiche la version du programme
 *
 * en: Display the version of the program
 **/

void popts_version (void)
{
  g_print ("%s %s\n", PACKAGE_COMMAND, DTAGS_VERSION);
  exit (0);
}

/*****************************************************************************/
/*** Traduction - Translation */
/*****************************************************************************/

/**
 * translation:
 * @file_out: output file location
 *
 * fr: Traduit le fichier
 *
 * en: Translates the file
 **/

void translation (gchar *file_out)
{
  gint i, j;
  FILE *fp;
  XmlDoc *doc;
  XmlNode *node;
  GString *string;
  gchar **string2;
  gchar **string3;
  guint readden;
  GIOChannel *file;

  /*** Dcoupage - Cutting */
  string = string_file ("tags");
  doc = xmlNewDoc ("1.0");
  doc->xmlRootNode = xmlNewDocNode (doc, NULL, "tags", NULL);
  string2 = g_strsplit (string->str, "\n", string->len);
  i=0;
  while (string2[i])
    {

      /*** Entte de Exuberant Ctags - Exuberant Ctags header */
      if ((strstr (string2[i], "!_TAG_FILE_FORMAT")) || 
	  (strstr (string2[i], "!_TAG_FILE_SORTED")) || 
	  (strstr (string2[i], "!_TAG_PROGRAM_AUTHOR")) || 
	  (strstr (string2[i], "!_TAG_PROGRAM_NAME")) || 
	  (strstr (string2[i], "!_TAG_PROGRAM_URL")) || 
	  (strstr (string2[i], "!_TAG_PROGRAM_VERSION")))
	{
	  i++;
	  continue;
	}

      /*** Champs - Fields */
      /*** Commande - Command : ctags-exuberant --fields=afiKmnz file.c */
      /*** Format : 'TD_MSG_MESSAGE	td_app.h	/^  TD_MSG_MESSAGE, \/*** Message message *\/$/;"	kind:enumerator	line:72' */
      string3 = g_strsplit (string2[i], "\t", strlen (string2[i]));
      node = xmlNewChild (doc->xmlRootNode, NULL, "tag", NULL);
      j=0;
      while (string3[j])
	{
	  switch (j)
	    {
	    case 0:
	      xmlSetProp (node, "name", g_strdup (string3[j]));
	      break;
	    case 1:
	      xmlSetProp (node, "file", g_strdup (string3[j]));
	      break;
	    case 2:
	      xmlSetProp (node, "text", g_strdup (string3[j]));
	      break;
	    case 3:
	      xmlSetProp (node, "type", g_strndup (string3[j]+5, strlen (string3[j])-5));
	      break;
	    case 4:
	      xmlSetProp (node, "line", g_strndup (string3[j]+5, strlen (string3[j])-5));
	      break;
	    default:
	      break;
	    }
	  j++;
	}
      i++;
    }

  /*** Enregistrement - Save */
  fp = fopen (file_out, "w");
  if (!fp)
    {
      g_error ("dtags-tags: opening XML file failed");
      xmlFreeDoc (doc);
      return;
    }
  fclose (fp);
  /* FIXME: libxml2 : attente d'une version plus mature - libxml2 : wait a more mature version */ 
  /* if (base->encoding) */
  /* { */
  /* if (xmlSaveFileEnc (file, doc, base->encoding)<0) */
  /* { */
  /* td_app_message (g_strdup_printf (_("Saving geometry '%s'"), file), TD_MSG_FAILED); */
  /* xmlFreeDoc (doc); */
  /* return FALSE; */
  /* } */
  /* } */
  /* else */
  if (xmlSaveFile (file_out, doc)<0)
    {
      g_error ("dtags-tags: saving XML file failed");
      xmlFreeDoc (doc);
      return;
    }
  xmlFreeDoc (doc);
}

/*****************************************************************************/
/*** Principale - Main */
/*****************************************************************************/

/**
 * popts_about:
 *
 * fr: Affiche le  propos du programme
 *
 * en: Display the about of the program
 **/

void popts_about (void)
{
  g_print ("%s %s : Balises pour documentation - Tags for documentation\n", PACKAGE_COMMAND, DTAGS_VERSION);
  g_print ("Copyright (c) 2001 Philippe Roy\n");
  g_print ("Author : Philippe Roy <ph_roy@toutdoux.org>\n");
  g_print ("dtags-tags is a free software, covered by the GNU General Public License. (http://www.gnu.org)\n");
  g_print ("dtags-tags is a tool developped for the ToutDoux project. (http://www.toutdoux.org)\n");
  exit (0);
}

/**
 * popts_def:
 *
 * fr: Definition des options de la ligne de commande
 *
 * en: Definition of the options of command line
 **/

void popts_def (void)
{
  PACKAGE_COMMAND = "dtags-tags";
  popts[0] = popt_def (NULL, "about", NULL, "About");
  popts[1] = popt_def ("v", "version", NULL, "Version");
  popts[2] = popt_def ("i", "input", "<source files>", "Specify the source input files (obligatory)");
  popts[3] = popt_def ("o", "output", "<xml file>", "Specify the XML output file (obligatory)");
};

/**
 * main:
 * @argc: counter of command line options used
 * @argv[]: arraw of command line options used
 *
 * fr: Procdure principale du programme
 *
 * en: Main procedure of the program
 *
 * Return value: -1 on error
 **/

int main (gint argc, char *argv[])
{
  FILE *file_in;
  FILE *file_out;
  void *ctx;
  GHashTable *dico;

  /*** Popts */
  popts_def();
  popts_parse (argc, argv, 4, popts);

  /*** Ctags */
  remove ("tags");
  if (system (g_strdup_printf ("ctags-exuberant --fields=aiKmnz %s", popts[2]->value))!=0)
    return 0;

  /*** Vrification des fichiers - Files checking */
  file_in = fopen ("tags", "r");
  if (file_in == NULL)
    g_error ("dtags-tags: reading tags input file : error in opening");
  fclose (file_in);
  file_out = fopen (popts[3]->value, "w");
  if (file_out == NULL)
    g_error ("dtags-tags: reading XML output file : error in opening");
  fclose (file_out);

  /*** Traduction - Translation */
  translation (popts[3]->value);
  remove ("tags");
  return 0;
}
