/**
 * td_app:
 * @title: TdApp
 * @subtitle: Application
 * @project: Toutdoux
 * @lang: fr,en
 * @authors: Philippe Roy <ph_roy@toutdoux.org>
 * @copyright: Copyright (c) 2000-2001 Philippe Roy
 * @license: GNU GPL
 *
 * fr: Object application
 *
 * en: Application object
 **/

/*
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <guile/gh.h>
#include <gnome.h>

/*****************************************************************************/
/*** Macros */
/*****************************************************************************/

#define TD_TYPE_APP (td_app_get_type())
#define TD_APP(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_APP, TdApp))
#define TD_APP_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_APP, TdAppClass))
#define TD_IS_APP(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_APP))
#define TD_IS_APP_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_APP))

/*****************************************************************************/
/*** Enumration - Enumeration */
/*****************************************************************************/

/**
 * TdMsg:
 *
 * fr: Type de message
 *
 * en: Message type
 **/

typedef enum {
  TD_MSG_DONE, /*** Message russit - Message done */
  TD_MSG_TESTED, /*** Message test - Message tested */
  TD_MSG_PLUGINS, /*** Message greffon - Message plug-in */
  TD_MSG_GUILE, /*** Message guile command */
  TD_MSG_OS, /*** Message os command */
  TD_MSG_SQL, /*** Message sql */
  TD_MSG_SQL_CACHE, /*** Message sql cache */
  TD_MSG_FUNCTION, /*** Message fonction - Message function */
  TD_MSG_FAILED, /*** Message chou - Message failed */
  TD_MSG_STOP, /*** Message stop */
  TD_MSG_BEGIN, /*** Message dbut - Message begin */
  TD_MSG_END, /*** Message fin - Message end */
  TD_MSG_MESSAGE, /*** Message message */
  TD_MSG_PROGRESS, /*** Message en cours - Message progress */
  TD_MSG_YES, /*** Message oui - Message yes */
  TD_MSG_NO, /*** Message non - Message no */
} TdMsg;

/**
 * TdModeEcho:
 *
 * fr: Echo mode
 *
 * en: Echo mode
 **/

typedef enum {
  TD_MODE_ECHO_0, /*** NULL */
  TD_MODE_ECHO_ALL_COLORS, /*** Echo tout en couleur - Echo all with colors */
  TD_MODE_ECHO_COLORS, /*** Echo en couleur - Echo colored */
  TD_MODE_ECHO_ALL_BW, /*** Echo all en noir et blanc - Echo all whitout colors */
  TD_MODE_ECHO_BW, /*** Echo en noir et blanc - Echo whitout colors */
  TD_MODE_ECHO_NO, /*** Sans cho - Whitout echo */
} TdModeEcho;


/*****************************************************************************/
/*** Structure */
/*****************************************************************************/

typedef struct _TdApp TdApp;
typedef struct _TdAppClass TdAppClass;

/**
 * _TdApp:
 *
 * fr: Object application
 *
 * en: Application object
 **/

struct _TdApp
{
  GtkObject object;
  gint pid; /*** Indentificatuer du processus - Process identifier */
  gchar *pid_database; /*** Base de donnes locale du processus - Locale database of process */
  GtkObject *palette; /*** Palette */
  GtkObject *bench; /*** Etabli - Bench */
  GtkObject *etabliste; /*** Etabli des listes - Bench of lists */
  GtkObject *command; /*** Zone de commande - Command zone */
  gboolean modified; /*** Drapeau de modifications non enregistres - Flag for unsaved changes */
  gint mode_echo; /*** Mode de l'echo de l'application - The echo mode of Application */
  GList *admin_field; /*** Champs d'administration - Administration fields */
  GtkObject *connect; /*** Connexion courante - Current connection */
  GtkObject *base; /*** Base courante - Current base */

  GHashTable *cmd; /*** Commandes - Commands */
  GCompletion *cmd_cmp; /*** Completion des commandes - Command completion */
  GtkAccelGroup *cmd_accel; /*** Groupe des acclrateur - Accelerators group */
  GtkWidget *menu_main;  /*** Menu principale - Main menu */
  GtkWidget *menu_palette; /*** Menu de la palette - Palette menu */
  GtkWidget *menu_favorites; /*** Menu des favoris - Favorites menu */
  GtkWidget *menu_templates; /*** Menu des gabarits - Templates menu */
  GtkWidget *menu_commands; /*** Menu des commandes - Commands menu */
  GtkWidget *menu_history; /*** Menu de l'historique - History menu */

  GtkObject *about; /*** Description */
  GHashTable *custom; /*** Valeurs de la personnalisation - Customize values */
  GHashTable *mod_core; /*** Modules noyaux - Core modules */
  GHashTable *mod_data; /*** Modules de donnes - Data modules */
  GHashTable *mod_filter; /*** Modules filtre - Filter modules */
  GList *process; /*** Liste des processus - Process list */

  GList *function; /*** Liste des fonctions - Functions list */
  GList *function_input; /*** Liste des champs lis - Linked fields list */
};

/**
 * _TdApp:
 *
 * fr: Object application
 *
 * en: Application object
 **/

struct _TdAppClass
{
  GtkObjectClass parent_class;
  void (*add_admin_field) (gchar *field);
  void (*add_cmd) (gchar *name, Scm (*function)(), int required, int optional, int rest);
  void (*set_menu_main) (GtkWidget *menu_main);
  void (*set_menu_palette) (GtkWidget *menu_palette);
  void (*set_menu_favorites) (GtkWidget *menu_favorites);
  void (*set_menu_templates) (GtkWidget *menu_templates);
  void (*set_menu_commands) (GtkWidget *menu_commands);
  void (*set_menu_history) (GtkWidget *menu_history);
  void (*set_current) (GtkObject *connect, GtkObject *base);
  void (*set_modified) (gboolean modified);
  void (*add_function) (GtkObject *function);
  void (*create) (void);
  void (*quit) (TdApp *app);
};

/*****************************************************************************/
/*** Arguments */
/*****************************************************************************/

static void td_app_set_modified (gboolean modified);
static void td_app_set_mode_echo (gint mode_echo);
static void td_app_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_app_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/*** Initialisation */
/*****************************************************************************/

static void td_app_init (TdApp *app);
static void td_app_class_init (TdAppClass *klass);
GtkType td_app_get_type (void);
GtkObject* td_app_new (void);
void td_app_quit (TdApp *app);

/*****************************************************************************/
/*** Affectations - Allocations*/
/*****************************************************************************/

void td_app_add_admin_field (gchar *field);
void td_app_add_cmd (gchar *name, Scm (*function)(), int required, int optional, int rest);
void td_app_set_menu_main (GtkWidget *menu_main);
void td_app_set_menu_palette (GtkWidget *menu_palette);
void td_app_set_menu_favorites (GtkWidget *menu_favorites);
void td_app_set_menu_templates (GtkWidget *menu_templates);
void td_app_set_menu_commands (GtkWidget *menu_commands);
void td_app_set_menu_history (GtkWidget *menu_history);
void td_app_set_current (GtkObject *connect, GtkObject *base);
gboolean td_app_add_mod (GtkObject *mod, gboolean init);
void td_app_add_process (GtkObject *process);
void td_app_add_function (GtkObject *function);

/*****************************************************************************/
/*** Commandes - Commands */
/*****************************************************************************/

void td_app_create (void);
void td_app_message (gchar *message, TdMsg type);
void td_app_action_function (gchar *table, GtkObject *mod);
TdModeEcho td_app_mode_echo_parse (gchar *value);

/*****************************************************************************/
/*** Paramtrage - Parameters */
/*****************************************************************************/

void td_app_custom_load (void);
gchar* td_app_custom_value (gchar *category, gchar *group, gchar *option);
void td_app_cmd_load (void);
void td_app_cmd (GtkWidget *widget, gchar *command);

/*****************************************************************************/
/*** Verrou - Lock */
/*****************************************************************************/

static void td_app_lock_add (void);
static void td_app_lock_update (gchar *file);
static void td_app_lock_remove (gint pid);
